/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class FermerToutesLesSessions {
    private static Logger log = Logger.getLogger(FermerToutesLesSessions.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                Resultat resultat = new Resultat("Fermer toutes les sessions actives de la carte ");
                try {
                    CK_TOKEN_INFO cK_TOKEN_INFO = pKCS11.C_GetTokenInfo(l);
                    if (cK_TOKEN_INFO != null) {
                        resultat.appendTraitement(new String(cK_TOKEN_INFO.label).trim() + " (C_CloseAllSessions)");
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
                try {
                    pKCS11.C_CloseAllSessions(l);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultat.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultat;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(16, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(16, "Une erreur inattendue est survenue");
        }
    }
}

